package data.scripts.everyframe;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.Vector2f;

/*
 closest to 315.4 deg: 412 units away or 294,-290
 closest to 291 deg: 382 units away or 137,-357
 closest to 249 deg: 380 units away or -136,-355
 closest to 225.8 deg: 384 units away or -268,-276
 closest to 133.1 deg: 390 units away or -267,285
 closest to 110.4 deg: 389 units away or -136,365
 closest to 69.4 deg: 393 units away or 138,368
 closest to 45.6 deg: 420 units away or 294,300
 */
public class SWP_FluxDisturberPlugin extends BaseEveryFrameCombatPlugin {

    public static final float DISTURBER_EMPPERSECOND = 500f;
    public static final float DISTURBER_FLUXPERSECOND = 1000f;
    public static final float DISTURBER_INTERVAL = 0.25f;
    public static final float DISTURBER_RANGE = 2500f;
    public static final float MAX_TARGETS = 15f;

    private static final String DATA_KEY = "SWP_FluxDisturber";

    public static void addDisturbing(ShipAPI ship, float effectLevel) {
        final LocalData localData = (LocalData) Global.getCombatEngine().getCustomData().get(DATA_KEY);
        if (localData == null) {
            return;
        }

        final Map<ShipAPI, Float> disturberList = localData.disturberList;
        final Map<ShipAPI, IntervalUtil> trackerList = localData.trackerList;

        if (disturberList.containsKey(ship)) {
            disturberList.put(ship, effectLevel);
        } else {
            disturberList.put(ship, effectLevel);
            trackerList.put(ship, new IntervalUtil(DISTURBER_INTERVAL, DISTURBER_INTERVAL));
        }
    }

    public static void removeDisturbing(ShipAPI ship) {
        final LocalData localData = (LocalData) Global.getCombatEngine().getCustomData().get(DATA_KEY);
        if (localData == null) {
            return;
        }

        final Map<ShipAPI, Float> disturberList = localData.disturberList;
        final Map<ShipAPI, IntervalUtil> trackerList = localData.trackerList;

        disturberList.remove(ship);
        trackerList.remove(ship);
    }

    private CombatEngineAPI engine;

    @Override
    public void advance(float amount, List<InputEventAPI> events) {
        if (engine == null) {
            return;
        }

        if (engine.isPaused()) {
            return;
        }

        final LocalData localData = (LocalData) engine.getCustomData().get(DATA_KEY);
        final Map<ShipAPI, Float> disturberList = localData.disturberList;
        final Map<ShipAPI, IntervalUtil> trackerList = localData.trackerList;

        for (Map.Entry<ShipAPI, Float> entry : disturberList.entrySet()) {
            ShipAPI ship = entry.getKey();

            IntervalUtil tracker = trackerList.get(ship);

            tracker.advance(amount * ship.getMutableStats().getTimeMult().getModifiedValue());

            float effectLevel = entry.getValue();
            float glowRand = (float) Math.random();

            List<WeaponAPI> weapons = ship.getAllWeapons();
            for (WeaponAPI weapon : weapons) {
                if (weapon.getId().contentEquals("ssp_cathedralglow1")) {
                    if (effectLevel > 0) {
                        weapon.getAnimation().setFrame(1);
                        SpriteAPI sprite = weapon.getSprite();

                        sprite.setAdditiveBlend();
                        sprite.setColor(new Color(150, 100, 200, (int) (255f * effectLevel * (glowRand * 0.5f + 0.5f))));
                    } else {
                        weapon.getAnimation().setFrame(0);
                    }
                }

                if (weapon.getId().contentEquals("ssp_cathedralglow2")) {
                    if (effectLevel > 0) {
                        weapon.getAnimation().setFrame(1);
                        SpriteAPI sprite = weapon.getSprite();

                        sprite.setAdditiveBlend();
                        sprite.setColor(new Color(200, 150, 255, (int) (255f * effectLevel * (glowRand * 0.5f + 0.5f))));
                    } else {
                        weapon.getAnimation().setFrame(0);
                    }
                }
            }

            if (tracker.intervalElapsed()) {
                List<ShipAPI> targets = CombatUtils.getShipsWithinRange(ship.getLocation(), DISTURBER_RANGE);
                Iterator<ShipAPI> iter = targets.iterator();
                while (iter.hasNext()) {
                    ShipAPI target = iter.next();
                    if (target.isHulk() || target == ship ||
                            (target.isFighter() && target.getOwner() == ship.getOwner()) ||
                            target.getFluxTracker().isOverloadedOrVenting() ||
                            target.getCollisionClass() == CollisionClass.NONE) {
                        iter.remove();
                    }
                }

                float chance = Math.min(MAX_TARGETS / targets.size(), 1f);
                iter = targets.iterator();

                while (iter.hasNext()) {
                    ShipAPI target = iter.next();
                    if (target == ship) {
                        continue;
                    }
                    if ((float) Math.random() >= chance) {
                        continue;
                    }
                    target.getFluxTracker().increaseFlux(DISTURBER_FLUXPERSECOND * effectLevel * DISTURBER_INTERVAL,
                                                         true);
                    Vector2f origin = new Vector2f(ship.getLocation());
                    float angle = VectorUtils.getAngle(ship.getLocation(), target.getLocation()) - ship.getFacing();
                    if (angle < 0f) {
                        angle += 360f;
                    }
                    float distance;
                    if (angle >= 0f && angle < 57.5f) {
                        distance = 420f;
                        angle = 45.6f;
                    } else if (angle >= 57.5f && angle < 89.9f) {
                        distance = 393f;
                        angle = 69.4f;
                    } else if (angle >= 89.9f && angle < 121.75f) {
                        distance = 389f;
                        angle = 110.4f;
                    } else if (angle >= 121.75f && angle < 179.45f) {
                        distance = 390f;
                        angle = 133.1f;
                    } else if (angle >= 179.45f && angle < 237.4f) {
                        distance = 384f;
                        angle = 225.8f;
                    } else if (angle >= 237.4f && angle < 270f) {
                        distance = 380f;
                        angle = 249f;
                    } else if (angle >= 270f && angle < 303.2f) {
                        distance = 382f;
                        angle = 291f;
                    } else {
                        distance = 412f;
                        angle = 315.4f;
                    }
                    angle += ship.getFacing();
                    if (angle >= 360f) {
                        angle -= 360f;
                    }

                    origin.x += distance;
                    origin = VectorUtils.rotateAroundPivot(origin, ship.getLocation(), angle, origin);
                    ShipAPI empTarget = target;
                    if (Math.random() < Math.max(1f / targets.size(), 1 / MAX_TARGETS)) {
                        Global.getCombatEngine().spawnEmpArc(ship, origin, ship, empTarget, DamageType.ENERGY, 0.0f,
                                                             DISTURBER_EMPPERSECOND * effectLevel *
                                                             DISTURBER_INTERVAL, 100000f,
                                                             "disabled_medium", 20f * effectLevel, new Color(150, 100,
                                                                                                             200,
                                                                                                             (int) (200f *
                                                                                                                    effectLevel +
                                                                                                                    55f)),
                                                             new Color(255, 255, 255, (int) (200f * effectLevel + 55f))
                        );
                    } else {
                        Global.getCombatEngine().spawnEmpArc(ship, origin, ship, empTarget, DamageType.ENERGY, 0.0f,
                                                             DISTURBER_EMPPERSECOND * effectLevel * DISTURBER_INTERVAL,
                                                             100000f,
                                                             null,
                                                             20f * effectLevel,
                                                             new Color(150, 100, 200, (int) (200f * effectLevel + 55f)),
                                                             new Color(255, 255, 255, (int) (200f * effectLevel + 55f))
                        );
                    }
                }

            }
        }
    }

    @Override
    public void init(CombatEngineAPI engine) {
        this.engine = engine;
        Global.getCombatEngine().getCustomData().put(DATA_KEY, new LocalData());
    }

    private static final class LocalData {

        final Map<ShipAPI, Float> disturberList = new HashMap<>(2);
        final Map<ShipAPI, IntervalUtil> trackerList = new HashMap<>(2);
    }
}
